package com.xebialabs.xlrelease.domain.delivery

import com.xebialabs.deployit.plugin.api.udm.Property
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult.{completed, failed, inProgress}
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus._

import java.util
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._
import scala.jdk.OptionConverters.RichOptional

class TrackedItemStatusChangeSubscriber extends Subscriber {
  @BeanProperty
  @Property
  var stageId: String = _
  @BeanProperty
  @Property
  var itemIds: java.util.List[String] = new util.ArrayList[String]()
  @BeanProperty
  @Property
  var itemStatus: TrackedItemStatus = _

  override def validate(delivery: Delivery): Unit = {
    delivery.getStageByIdOrTitle(this.stageId)
    itemIds.forEach(itemId => delivery.getItemByIdOrTitle(itemId))
  }

  override def evaluate(delivery: Delivery): SubscriptionResult = {
    val stage = delivery.getStageByIdOrTitle(stageId)
    val resolvedItems = itemIds.asScala.map { itemId =>
      ResolvedItem(delivery.getItemByIdOrTitle(itemId), stage.findItemById(itemId).toScala.map(i => i.getStatus))
    }

    if (resolvedItems.exists(_.item.isDescoped)) {
      failed(s"Unable to complete task, the following tracked items are de-scoped:\n " +
        s"* ${resolvedItems.filter(_.item.isDescoped).map(_.item.getTitle).sorted.mkString("\n * ")}")
    } else if (itemStatus == NOT_READY && resolvedItems.forall(_.statusInStage.isDefined)) {
      completed(s"All tracked items are available in stage '${stage.getTitle}'")
    } else if (itemStatus == READY && resolvedItems.exists(_.statusInStage.exists(status => status == SKIPPED))) {
      failed(s"Unable to complete task, the following tracked items are skipped in stage '${stage.getTitle}':\n " +
        s"* ${resolvedItems.filter(_.statusInStage.exists(status => status == SKIPPED)).map(_.item.getTitle).sorted.mkString("\n * ")}")
    } else if (itemStatus == READY && resolvedItems.forall(_.statusInStage.exists(status => status == READY))) {
      completed(s"All tracked items are completed in stage '${stage.getTitle}'")
    } else {
      inProgress()
    }
  }

  def matches(delivery: Delivery, itemId: String, stageId: Option[String] = None, status: Option[TrackedItemStatus] = None): Boolean = {
    this.itemIds.contains(itemId) &&
      (stageId.isEmpty || this.stageId == stageId.get) &&
      (status.isEmpty || (this.itemStatus == status.get && allItemsHaveStatus(delivery, stageId.get, status.get)))
  }

  private def allItemsHaveStatus(delivery: Delivery, stageId: String, status: TrackedItemStatus): Boolean = {
    val stage = delivery.getStageByIdOrTitle(stageId)
    itemIds.asScala.forall {
      stage.findItemById(_).toScala.exists(stageItem => stageItem.getStatus == status)
    }
  }

}
