package com.xebialabs.xlrelease.domain.delivery

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}

import scala.beans.BeanProperty


@Metadata(versioned = false)
abstract class Subscriber extends BaseConfigurationItem {
  @BeanProperty
  @Property
  var sourceId: String = _

  def validate(delivery: Delivery): Unit

  def evaluate(delivery: Delivery): SubscriptionResult

  def isEqual(subscriber: Subscriber): Boolean = {
    sourceId == subscriber.sourceId
  }
}
