package com.xebialabs.xlrelease.domain.calendar;

import java.util.Date;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(description = "Base class for all calendar entries", root = CONFIGURATION, versioned = false, virtual = true)
public abstract class CalendarEntry extends BaseConfigurationItem {
    @Property(description = "The label of the calendar event.")
    protected String label;

    @Property(description = "The start date and time of the calendar event.")
    protected Date startDate;

    @Property(description = "The end date and time of the calendar event.")
    protected Date endDate;

    public String getLabel() {
        return label;
    }

    public void setLabel(final String label) {
        this.label = label;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }
}
