package com.xebialabs.xlrelease.domain;

import static com.xebialabs.xlrelease.domain.Team.FOLDER_OWNER_TEAMNAME;
import static com.xebialabs.xlrelease.domain.Team.RELEASE_ADMIN_TEAMNAME;
import static com.xebialabs.xlrelease.domain.Team.TEMPLATE_OWNER_TEAMNAME;
import static com.xebialabs.xlrelease.security.XLReleasePermissions.EDIT_FOLDER_SECURITY;
import static com.xebialabs.xlrelease.security.XLReleasePermissions.EDIT_FOLDER_TEAMS;

public interface TeamPermissionOperations {
    String getTeamName();
    boolean hasPermission(String permission);

    default boolean isFolderOwnerTeam() {
        return hasPermission(EDIT_FOLDER_SECURITY.getPermissionName());
    }

    default boolean isReleaseAdminTeam() {
        return RELEASE_ADMIN_TEAMNAME.equals(getTeamName());
    }

    default boolean isTemplateOwnerTeam() {
        return TEMPLATE_OWNER_TEAMNAME.equals(getTeamName());
    }

    default boolean isFolderAdminTeam() {
        return !isFolderOwnerTeam() && hasPermission(EDIT_FOLDER_TEAMS.getPermissionName());
    }

    default boolean isSystemTeam() {
        return isReleaseAdminTeam() || isTemplateOwnerTeam() || FOLDER_OWNER_TEAMNAME.equals(getTeamName());
    }

}
