package com.xebialabs.xlrelease.domain

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS
import com.xebialabs.xlrelease.api.internal.InternalMetadata
import com.xebialabs.xlrelease.domain.status.ReleaseStatus
import com.xebialabs.xlrelease.repository.Ids.SEPARATOR

object ServerUrl {

  def convertToViewId(internalId: String): String = {
    if (internalId != null) {
      internalId.stripPrefix(APPLICATIONS.getRootNodeName + SEPARATOR)
        .replace('/', '-')
    } else {
      throw new IllegalArgumentException("Internal id is null")
    }
  }

  def buildUrl(serverUrl: String, release: Release): String = {
    val page: String = if (release.getStatus == ReleaseStatus.TEMPLATE) "templates" else "releases"
    s"$serverUrl#/$page$SEPARATOR${convertToViewId(release.getId)}"
  }
}

case class ServerUrl(url: String) extends InternalMetadata
