package com.xebialabs.xlrelease.domain;

import java.util.Date;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef @ShowOnlyPublicApiMembers
@Metadata(versioned = false)
public class Comment extends BaseConfigurationItem {

    @Property
    private String text;
    @Property
    private String author;
    @Property
    private Date date;
    @Property
    private Date creationDate;

    public Comment() {
    }

    public Comment(String id, String text, String author, Date date) {
        this.id = id;
        this.text = text;
        this.author = author;
        this.date = date;
    }

    @PublicApiMember
    public String getText() {
        return text;
    }

    @PublicApiMember
    public String getAuthor() {
        return author;
    }

    @PublicApiMember
    public void setAuthor(String author) {
        this.author = author;
    }

    @PublicApiMember
    public void setText(String text) {
        this.text = text;
    }

    @PublicApiMember
    public Date getDate() {
        return date;
    }

    @PublicApiMember
    public void setDate(Date date) {
        this.date = date;
        if (creationDate == null) {
            this.creationDate = date;
        }
    }

    @PublicApiMember
    public Date getCreationDate() {
        return creationDate;
    }

    @PublicApiMember
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

}
