package com.xebialabs.xlrelease.domain;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false, virtual = true)
public abstract class BaseArtifact extends BaseConfigurationItem implements SourceArtifact {
    public static final String PARENT_TITLE_PROPERTY_NAME = "parentTitle";
    public static final String PORTABLE_FILENAME_PROPERTY_NAME = "portableFilename";
    public static final String EXPORT_FILENAME_PROPERTY_NAME = "exportFilename";

    public static final String CONTENT_TYPE_PROPERTY_NAME = "contentType";


    private OverthereFile file;

    @Property
    private String contentType;

    @Property(isTransient = true)
    private String exportFilename;

    @Property(isTransient = true)
    private String portableFilename;

    @Property(isTransient = true)
    private String parentTitle;

    @Property
    private String fileUri;

    protected BaseArtifact() {
    }

    protected BaseArtifact(OverthereFile file, String contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    @Override
    public OverthereFile getFile() {
        return this.file;
    }

    @Override
    public void setFile(OverthereFile file) {
        this.file = file;
    }

    @Override
    public Set<String> getPlaceholders() {
        return Collections.emptySet();
    }

    @Override
    public void setPlaceholders(Set<String> placeholders) {
    }

    @Override
    public String getTextFileNamesRegex() {
        return "";
    }

    @Override
    public String getExcludeFileNamesRegex() {
        return "";
    }

    @Override
    public Map<String, String> getFileEncodings() {
        return Collections.emptyMap();
    }

    @Override
    public String getChecksum() {
        return "";
    }

    @Override
    public String getFileUri() {
        return fileUri;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public abstract String getExportDirectoryName();

    private String buildExportFileName() {
        if (null != getFile()) {
            return getExportDirectoryName() + "/" + getName() + "-" + getFile().getName();
        }
        return null;
    }

    public String getExportFilename() {
        if (exportFilename == null) {
            exportFilename = buildExportFileName();
        }
        return exportFilename;
    }

    public void setExportFilename(String exportFilename) {
        this.exportFilename = exportFilename;
    }

    public String getPortableFilename() {
        if (null == portableFilename) {
            portableFilename = buildPortableFilename();
        }
        return portableFilename;
    }

    public void setPortableFilename(final String portableFilename) {
        this.portableFilename = portableFilename;
    }

    private String buildPortableFilename() {
        if (null != getFile()) {
            return getExportDirectoryName() + "/" + getParentPrefix() + getFile().getName();
        }
        return null;
    }

    private String hash(String value) {
        return DigestUtils.sha1Hex(value);
    }

    private String getParentPrefix() {
        return parentTitle != null ? hash(parentTitle) + "/" : "";
    }

}
