package com.xebialabs.xlrelease.configuration;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseSettings;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;
import static java.lang.String.format;

@Metadata(root = CONFIGURATION, versioned = false, description = "Logo file (recommended size 24*100px)")
public class CustomLogoSettings extends BaseSettings {
    public static final String CUSTOM_LOGO_SETTINGS_ID = BASE_ID + "CustomLogoSettings";

    @Property(required = false)
    private String filename;

    @Property(required = false)
    private String contentType;

    @Property(required = false)
    private String content;

    public String getFilename() {
        return filename;
    }

    public void setFilename(final String filename) {
        this.filename = filename;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(final String contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return content;
    }

    public void setContent(final String content) {
        this.content = content;
    }

    public void validateContentType() {
        if (content != null && !CustomLogoContentType.getAllTypes().contains(this.contentType)) {
                throw new IllegalArgumentException(format(
                        "Content type %s not allowed. Allowed content types are: %s", this.contentType, CustomLogoContentType.getBrowserTypes().toString()));

        }

    }
}
