package com.xebialabs.xlrelease.risk.domain.riskassessors;


import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;

@Metadata(versioned = false)
@PublicApiRef
@ShowOnlyPublicApiMembers
abstract public class RiskAssessor extends BaseConfigurationItem {

    protected static final int OK_SCORE = 0;

    protected static final String OK_HEADLINE = "Release is on track";

    @Property(description = "The title of the risk assessor.")
    protected String title;

    @Property(required = false, description = "The description of the item.")
    protected String description;

    @Property(description = "The weight of the assessor in the total calculation.")
    protected int weight = 1;

    @Property(description = "Score given when assessor decides it needs scoring.", defaultValue = "0")
    protected int score;

    @Property(description = "A value used for ordering the assessors within a risk profile.", defaultValue = "100")
    protected String order;

    @Property(description = "Define a group to which this risk assessor belongs. Used for UI. Default is: Risk Assessors", defaultValue = "Risk Assessors")
    protected String group;

    @Property(description = "Define an icon for the risk assessor", defaultValue = "")
    protected String icon;

    public abstract RiskAssessment execute(Release release, RiskProfile riskProfile);

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    @PublicApiMember
    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    @PublicApiMember
    public int getWeight() {
        return weight;
    }

    public void setWeight(final int weight) {
        this.weight = weight;
    }

    @PublicApiMember
    public int getScore() {
        return score;
    }

    public void setScore(final int score) {
        this.score = score;
    }

    @PublicApiMember
    public String getOrder() {
        return order;
    }

    public void setOrder(final String order) {
        this.order = order;
    }

    @PublicApiMember
    public String getIcon() {
        return icon;
    }

    public void setIcon(final String icon) {
        this.icon = icon;
    }

    @PublicApiMember
    public String getGroup() {
        return group;
    }

    public void setGroup(final String group) {
        this.group = group;
    }
}
