package com.xebialabs.xlrelease.risk.domain.riskassessors;

import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

import com.xebialabs.xlrelease.domain.PlanItem;

import static java.lang.String.format;

abstract public class PlanItemDueDateRiskAssessor extends RiskAssessor {

    protected static final String PLAN_ITEM_OVERDUE_MESSAGE = "%s is overdue since %s";

    protected String formatMessage(PlanItem planItem) {
        LocalDateTime dueDate = planItem.getOrCalculateDueDate()
                .map(LocalDateTime::fromDateFields)
                .orElseThrow(() -> new IllegalStateException("Due date should be set or calculated."));

        DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
        return format(PLAN_ITEM_OVERDUE_MESSAGE, planItem.getTitle(), formatter.print(dueDate)).trim();
    }

}
