package com.xebialabs.xlrelease.risk.domain.riskassessors;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;

@Metadata(label = "OneTaskOverDueRiskAssessor", versioned = false)
public class OneTaskOverDueRiskAssessor extends PlanItemDueDateRiskAssessor {

    private static final String OVERDUE_TASKS_HEADLINE = "Release has overdue tasks";

    @Override
    public RiskAssessment execute(final Release release, final RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());

        List<Task> overdueTasks = release.getActiveTasks().stream().filter(Task::isOverdue)
                .collect(Collectors.toList());

        List<String> messages = new ArrayList<>();
        if (overdueTasks.size() == 1) {
            assessment.setHeadline(OVERDUE_TASKS_HEADLINE);
            assessment.setScore(riskProfile.getValueFor(getType()));
            overdueTasks.forEach(task -> messages.add(formatMessage(task)));
        } else {
            assessment.setScore(OK_SCORE);
            assessment.setHeadline(OK_HEADLINE);
        }

        assessment.setMessages(messages);
        return assessment;
    }
}
