package com.xebialabs.xlrelease.domain.utils

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.delivery._
import com.xebialabs.xlrelease.domain.delivery.conditions.ConditionGroup
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.repository.Ids.findInAncestry

import scala.jdk.OptionConverters._
import scala.reflect.ClassTag

object DeliveryUtils {

  def deliveryIdFrom(id: String): String = {
    Ids.deliveryIdFrom(id)
  }

  def transitionIdFrom(id: String): String = {
    classIdFrom[Transition](id)
  }

  def getItemsCompletedInAllStages(items: Seq[TrackedItem], stages: Seq[Stage]): Seq[TrackedItem] = {
    getItemsWithStatusInAllStages(items, stages, TrackedItemStatus.DONE_STATUSES.toSeq)
  }

  def getItemsWithStatusInAllStages(items: Seq[TrackedItem], stages: Seq[Stage], statuses: Seq[TrackedItemStatus]): Seq[TrackedItem] = {
    items.filter(item => stages.forall(hasAnyStatusInStage(_, item, statuses)))
  }

  def hasAnyStatusInStage(stage: Stage, item: TrackedItem, statuses: Seq[TrackedItemStatus]): Boolean = {
    stage.findItemById(item.getId).asScala.exists(stageItem => statuses.contains(stageItem.getStatus))
  }

  def isConditionGroup(condition: Condition): Boolean = condition.isInstanceOf[ConditionGroup]

  private def classIdFrom[T <: ConfigurationItem : ClassTag](classId: String): String = {
    findInAncestry(classId, Type.valueOf(implicitly[ClassTag[T]].runtimeClass).getName)
  }

}
