package com.xebialabs.xlrelease.domain.facet;

import java.util.Date;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS;
import static com.xebialabs.xlrelease.domain.Task.CATEGORY_INPUT;

/**
 * A Task reporting record.
 */
@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root = APPLICATIONS, versioned = false, virtual = true, description = "Base type for all immutable reporting records produced by tasks.")
public class TaskReportingRecord extends Facet {

    @Property(category = CATEGORY_INPUT, description = "Server base URL used to fetch data.", required = false)
    private String serverUrl;

    @Property(category = CATEGORY_INPUT, description = "Username used to authenticate to the server when fetching data.", required = false)
    private String serverUser;

    @Property(category = CATEGORY_INPUT, label = "Creation date", description = "Timestamp of when this record was created.")
    private Date creationDate;

    @Property(hidden = true, category = CATEGORY_INPUT, description = "Index of attempt to try task. 0 means task is started for the " +
            "first time, 1 means it failed once and is now being retried.", required = true)
    private int retryAttemptNumber;

    @Property(hidden = true, category = CATEGORY_INPUT,
            description = "Was this facet created via API. If not it means that XLR core created this facet from task attributes itself")
    private boolean createdViaApi;

    @PublicApiMember
    public String getServerUrl() {
        return serverUrl;
    }

    @PublicApiMember
    public void setServerUrl(final String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @PublicApiMember
    public String getServerUser() {
        return serverUser;
    }

    @PublicApiMember
    public void setServerUser(final String serverUser) {
        this.serverUser = serverUser;
    }

    @PublicApiMember
    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(final Date creationDate) {
        this.creationDate = creationDate;
    }

    public int getRetryAttemptNumber() {
        return retryAttemptNumber;
    }

    public void setRetryAttemptNumber(final int retryAttemptNumber) {
        this.retryAttemptNumber = retryAttemptNumber;
    }

    public boolean isCreatedViaApi() {
        return createdViaApi;
    }

    public void setCreatedViaApi(final boolean createdViaApi) {
        this.createdViaApi = createdViaApi;
    }

}
