package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.UserToken

sealed trait UserTokenEvent extends XLReleaseEvent

case class UserTokenCreatedEvent(userToken: UserToken) extends UserTokenEvent

case class UserTokenDeletedEvent(userToken: UserToken) extends UserTokenEvent

case class UserTokensDeletedEvent(tokenUser: String) extends UserTokenEvent

case class UserTokenAboutToExpireEvent(userToken: UserToken) extends UserTokenEvent
