package com.xebialabs.xlrelease.domain.events


/**
 * Private events related to Release Actor. Do not use them outside product codebase.
 */
sealed trait ReleaseActorEvent extends XLReleaseEvent

/**
 * Private event related to Release Actor. Do not use it outside product codebase.
 *
 * @param releaseId id of the release
 * @param actorPath Full String representation of actor path including the uid for the actor cell instance as URI fragment.
 *                  Created from ActorPath.toSerializationFormat.
 */
case class ReleaseActorStarted(releaseId: String, actorPath: String) extends ReleaseActorEvent

/**
 * Private event related to Release Actor. Do not use it outside product codebase.
 *
 * @param releaseId id of the release
 * @param actorPath Full String representation of actor path including the uid for the actor cell instance as URI fragment.
 *                  Created from ActorPath.toSerializationFormat.
 */
case class ReleaseActorStopped(releaseId: String, actorPath: String) extends ReleaseActorEvent
