package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.Link

/**
  * Common interface for domain events related to modification of links between sub-tasks of a parallel group.
  */
sealed trait LinkEvent extends XLReleaseEvent

/**
  * Event published when a link is created.
  * @param link the created link.
  */
case class LinkCreatedEvent(link: Link) extends LinkEvent

/**
  * Event published when a link is deleted.
  * @param link the link that was deleted.
  */
case class LinkDeletedEvent(link: Link) extends LinkEvent
