package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.{GateCondition, GateTask}

/**
  * Common interface for domain events related to gate condition modification.
  */
sealed trait GateConditionEvent extends XLReleaseEvent

/**
  * Event published when a gate condition is created.
  * @param task the gate task on which the condition was created.
  * @param gateCondition the condition that was created.
  */
case class GateConditionCreatedEvent(task: GateTask, gateCondition: GateCondition) extends GateConditionEvent

/**
  * Event published when a gate condition has been updated.
  * @param task the gate task to which the condition belongs.
  * @param original copy of the original gate condition before it was changed.
  * @param updated updated instance of the gate condition. You can use [[original]] to compare the texts of conditions.
  */
case class GateConditionUpdatedEvent(task: GateTask, original: GateCondition, updated: GateCondition) extends GateConditionEvent

/**
  * Event published when a gate condition has been deleted.
  * @param task the gate to which the condition belonged.
  * @param gateCondition the gate condition that has been deleted.
  */
case class GateConditionDeletedEvent(task: GateTask, gateCondition: GateCondition) extends GateConditionEvent
