package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.Category


sealed trait CategoryEvent extends XLReleaseEvent

/**
 * Event published when a new category is created.
 *
 * @param category the created category
 */
case class CategoryCreatedEvent(category: Category) extends CategoryEvent

/**
 * Event published when a category is updated.
 *
 * @param original the original category
 * @param updated  the updated category
 */
case class CategoryUpdatedEvent(original: Category, updated: Category) extends CategoryEvent

/**
 * Event published when a category is deleted.
 *
 * @param category the deleted category
 */
case class CategoryDeletedEvent(category: Category) extends CategoryEvent
