package com.xebialabs.xlrelease.domain.distributed.events

/**
 * Common interface for domain events related to task execution or modification.
 */
sealed trait DistributedTaskEvent extends DistributedXLReleaseEvent {
  def taskId: String
}

/**
 * Event published when the task status line has been updated. It could be that it's the same message as before.
 * @param taskId identifier of the task.
 * @param statusLine the status line of the task.
 */
case class DistributedTaskStatusLineUpdated(taskId: String, statusLine: String) extends DistributedTaskEvent
