package com.xebialabs.xlrelease.domain;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import static com.xebialabs.xlrelease.domain.ScriptHelper.HIDDEN;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false, virtual = true)
public abstract class ScheduledTrigger extends Trigger {

    @PublicApiMember
    @Property(defaultValue = "REPEAT", required = true, label = "Poll Type", description = "Type of polling to use; this is a repeatable period in seconds (for example, every 10 seconds) or a cron expression")
    private PollType pollType = PollType.REPEAT;

    @PublicApiMember
    @Property(defaultValue = "10", required = true, label = "Poll Interval", description = "Interval in seconds (REPEAT) or as a cron expression (CRON). The cron pattern is a list of six fields separated by a single space; these fields represent second, minute, hour, day, month, weekday. Month and weekday names can be given as the first three letters of their English names. For example: 0 0 * * * * = the top of every hour of every day; */10 * * * * * = every ten seconds; 0 0 9-17 * * MON-FRI = on the hour nine-to-five weekdays")
    private String periodicity = "10";

    @PublicApiMember
    @Property(required = false, category = HIDDEN, defaultValue = "false", description = "Set this property to true to trigger a new release on the initial trigger fire. Otherwise, the first release will be triggered on the next state change")
    private boolean initialFire = false;

    @Override
    public List<String> getInternalProperties() {
        ArrayList<String> properties = new ArrayList<>(super.getInternalProperties());
        properties.add("initialFire");
        return properties;
    }

    @PublicApiMember
    public PollType getPollType() {
        return pollType;
    }

    @PublicApiMember
    public void setPollType(final PollType pollType) {
        this.pollType = pollType;
    }

    @PublicApiMember
    public String getPeriodicity() {
        return periodicity;
    }

    @PublicApiMember
    public void setPeriodicity(final String periodicity) {
        this.periodicity = periodicity;
    }

    public boolean isInitialFire() {
        return initialFire;
    }

    public void setInitialFire(final boolean initialFire) {
        this.initialFire = initialFire;
    }
}
