package com.xebialabs.xlrelease.domain;

import java.util.*;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;

/**
 * Configuration object for external variables to lookup their value with.
 */
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, virtual = true, versioned = false)
public class ExternalVariableServer extends Configuration {
    
    @Property(description = "Address where the server can be reached")
    private String url;
    
    @Property(label = "Api Token", password = true, required = false, category = "Authentication")
    private String token;

    /**
     * Resolves a list of password variables from an external server implementation.
     *
     * This method is not part of public API. DO NOT use it.
     *
     * @param variables the password variables that need resolving
     * @return A map of external server values mapped to Variable#getKey()
     * @see Variable#getKey()
     */
    public Map<String, String> lookup(List<PasswordStringVariable> variables) {
        return Collections.emptyMap();
    }

    public String getToken() {
        return token;
    }
    
    public void setToken(final String token) {
        this.token = token;
    }
    
    public String getUrl() {
        return url;
    }
    
    public void setUrl(final String url) {
        this.url = url;
    }
    
    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        
        if (!super.equals(o)) {
            return false;
        }
        
        final ExternalVariableServer server = (ExternalVariableServer) o;

        return Objects.equals(token, server.token);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), token);
    }
}
