package com.xebialabs.xlrelease.configuration;

import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false)
public class TaskAccess extends BaseConfiguration {

    public static final String TASK_ACCESS_PATH = "Configuration/taskAccess";

    @Property(required = false)
    private boolean isAllowedToAll;

    @Property(required = false)
    private List<String> roles = newArrayList();

    public TaskAccess() {
    }

    public TaskAccess(String taskType, boolean isAllowedToAll, List<String> roles) {
        checkArgument(isTaskAccessValid(isAllowedToAll, roles), "Roles must be empty when task access is allowed to all");
        this.id = getTaskAccessId(taskType);
        this.roles = roles;
        this.isAllowedToAll = isAllowedToAll;

        this.setTitle(taskType);
    }

    private boolean isTaskAccessValid(boolean isAllowedToAll, List<String> roles) {
        return !isAllowedToAll || roles.isEmpty();
    }

    public static String getTaskAccessId(String taskType) {
        return TASK_ACCESS_PATH + '/' + taskType;
    }

    public List<String> getRoles() {
        return roles;
    }

    public void setRoles(final List<String> roles) {
        this.roles = roles;
    }

    public boolean isAllowedToAll() {
        return isAllowedToAll;
    }

    public void setAllowedToAll(boolean isAllowedToAll) {
        this.isAllowedToAll = isAllowedToAll;
    }
}
