package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false)
public class AuditReportSettings extends BaseConfiguration {

    public static final String AUDIT_REPORT_SETTINGS_ID = "Configuration/settings/AuditReportSettings";

    @Property(defaultValue = "10", required = false, label = "Delete release audit reports older than")
    private Integer reportsRetentionPeriod; // in days

    public void validate() {
        Preconditions.checkArgument(reportsRetentionPeriod > 0, "Audit report retention period must be greater than 0 days.");
    }

    public Integer getReportsRetentionPeriod() {
        return reportsRetentionPeriod;
    }

    public void setReportsRetentionPeriod(Integer reportsRetentionPeriod) {
        this.reportsRetentionPeriod = reportsRetentionPeriod;
    }

}