package com.xebialabs.xlrelease.api.v1.forms;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import static com.xebialabs.xlrelease.variable.VariableHelper.formatVariableIfNeeded;
import static java.lang.String.format;

@PublicApiRef
public class VariableOrValue {

    protected String variable;
    protected Object value;

    public VariableOrValue() {
    }

    public VariableOrValue(final String variable, final Object value) {
        this.variable = variable;
        this.value = value;
    }

    public String getVariable() {
        return variable;
    }

    public void setVariable(final String variable) {
        this.variable = variable;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(final Object value) {
        this.value = value;
    }

    @Override
    public String toString() {
        if (variable != null) {
            return format("variable %s", formatVariableIfNeeded(variable));
        } else {
            return format("value '%s'", value);
        }
    }
}
