/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BasePythonScript;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned=false)
public class PythonScript
extends BasePythonScript {
    @Property(required=false, asContainment=true)
    private CustomScriptTask customScriptTask;
    @Property(required=false, hidden=true, description="URI of the HTML file to render the task for custom script tasks")
    private String configurationUri;
    @Property(hidden=true, defaultValue="32768", description="Maximum size of output property values of type string. Default value is 32768")
    private int maxOutputPropertySize = 32768;
    @Property(hidden=true, required=false, defaultValue="true", category="internal", description="The task is supported in a workflow or not")
    private boolean supportedInWorkflow;
    @Property(required=false, description="Keep the previous output properties on retry")
    private boolean keepPreviousOutputPropertiesOnRetry;
    public static final String PYTHON_SCRIPT_ID = "PythonScript";
    public static final String PYTHON_SCRIPT_PROPERTY = "pythonScript";
    public static final String CUSTOM_SCRIPT_TASK_PROPERTY = "customScriptTask";
    private static final String CONFIGURATION_URI_PROPERTY = "configurationUri";
    private static final String TASK_COLOR_PROPERTY = "taskColor";
    private static final String ICON_CLASS_PROPERTY = "iconClass";
    private static final String ICON_LOCATION_PROPERTY = "iconLocation";
    private static final String OUTPUT_VAR_HELP_TEXT_PROPERTY = "outputVarHelpText";
    private static final String SUPPORTED_IN_WORKFLOW_PROPERTY = "supportedInWorkflow";
    public static final List<String> UPDATEABLE_PROPERTIES = Arrays.asList("configurationUri", "taskColor", "iconClass", "iconLocation", "outputVarHelpText", "supportedInWorkflow");

    public Collection<PropertyDescriptor> getPropertiesWithVariables() {
        PythonScriptDefinition scriptDefinition = new PythonScriptDefinition(this.getType());
        return scriptDefinition.getInputProperties().stream().filter(PythonScriptDefinition.ofKind(PropertyKind.STRING, PropertyKind.LIST_OF_STRING, PropertyKind.SET_OF_STRING, PropertyKind.MAP_STRING_STRING)).collect(Collectors.toList());
    }

    public Collection<PropertyDescriptor> getInputProperties() {
        return new PythonScriptDefinition(this.getType(), true).getInputProperties();
    }

    public Collection<PropertyDescriptor> getOutputProperties() {
        return new PythonScriptDefinition(this.getType(), true).getOutputProperties();
    }

    public Collection<PropertyDescriptor> getTransitionalAndOutputProperties() {
        return new PythonScriptDefinition(this.getType(), true).getTransitionalAndOutputProperties();
    }

    public Collection<PropertyDescriptor> getTransitionalProperties() {
        return new PythonScriptDefinition(this.getType(), true).getTransitionalProperties();
    }

    @PublicApiMember
    public CustomScriptTask getCustomScriptTask() {
        return this.customScriptTask;
    }

    @PublicApiMember
    public void setCustomScriptTask(CustomScriptTask customScriptTask) {
        this.customScriptTask = customScriptTask;
    }

    @PublicApiMember
    public String getIconLocation() {
        return (String)this.getProperty(ICON_LOCATION_PROPERTY);
    }

    @PublicApiMember
    public String getOutputVarHelpText() {
        return (String)this.getProperty(OUTPUT_VAR_HELP_TEXT_PROPERTY);
    }

    @PublicApiMember
    public String getTaskColor() {
        return (String)this.getProperty(TASK_COLOR_PROPERTY);
    }

    @PublicApiMember
    public String getIconClass() {
        return (String)this.getProperty(ICON_CLASS_PROPERTY);
    }

    public int getMaxOutputPropertySize() {
        return this.maxOutputPropertySize;
    }

    public void setMaxOutputPropertySize(int maxOutputPropertySize) {
        this.maxOutputPropertySize = maxOutputPropertySize;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public boolean isSupportedInWorkflow() {
        return this.supportedInWorkflow;
    }

    public void setSupportedInWorkflow(boolean supportedInWorkflow) {
        this.supportedInWorkflow = supportedInWorkflow;
    }

    @Override
    public String getScript() throws IOException {
        return ScriptHelper.readScript(this.customScriptTask.getScriptPath());
    }

    @Override
    public String getAbortScript() throws IOException {
        return ScriptHelper.readScript(this.customScriptTask.getAbortScriptPath());
    }

    public Set<String> getAllSyntheticPropertyKeys() {
        return new HashSet<String>(this.syntheticProperties.keySet());
    }

    public boolean isKeepPreviousOutputPropertiesOnRetry() {
        return this.keepPreviousOutputPropertiesOnRetry;
    }

    public void setKeepPreviousOutputPropertiesOnRetry(boolean keepPreviousOutputPropertiesOnRetry) {
        this.keepPreviousOutputPropertiesOnRetry = keepPreviousOutputPropertiesOnRetry;
    }
}

