/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class ArchivingSettings
extends BaseConfiguration {
    public static final String ARCHIVING_SETTINGS_ID = "Configuration/settings/ArchivingSettings";
    public static final int DEFAULT_SEARCH_PAGE_SIZE = 20;
    private static final String DEFAULT_SEARCH_PAGE_SIZE_AS_STRING = "20";
    @Property(defaultValue="720", required=false, label="Archive completed releases older than")
    private Integer releaseAgeToDeleteFromJcr;
    @Property(defaultValue="16 * * * * *", required=false, hidden=true, label="Schedule for the job that checks for releases to archive (advanced)")
    private String archivingJobCronSchedule;
    @Property(defaultValue="true", required=false, hidden=true, label="Enable archiving")
    private boolean enabled;
    @Property(defaultValue="true", required=false, hidden=false, label="Enable pre-archiving")
    private boolean preArchivingEnabled;
    @Property(defaultValue="20", required=false, hidden=true, label="Number of archivable releases to retrieve from the repository in a single search query")
    private Integer searchPageSize;
    @Property(defaultValue="20", required=false, hidden=true, label="Number of seconds that archiving is allowed to run before it is paused until the next time it is scheduled")
    private Integer maxSecondsPerRun;
    @Property(defaultValue="1", required=false, hidden=true, label="Number of seconds to sleep between archiving individual releases within a single run")
    private Integer sleepSecondsBetweenReleases;

    public void validate() {
        Preconditions.checkArgument((this.releaseAgeToDeleteFromJcr >= 0 ? 1 : 0) != 0, (Object)"releaseAgeToDeleteFromJcr must be greater than or equal to 0 hours.");
    }

    public Integer getReleaseAgeToDeleteFromJcr() {
        return this.releaseAgeToDeleteFromJcr;
    }

    public String getArchivingJobCronSchedule() {
        return this.archivingJobCronSchedule;
    }

    public void setReleaseAgeToDeleteFromJcr(Integer releaseAgeToDeleteFromJcr) {
        this.releaseAgeToDeleteFromJcr = releaseAgeToDeleteFromJcr;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getPreArchivingEnabled() {
        return this.preArchivingEnabled;
    }

    public void setPreArchivingEnabled(Boolean enabled) {
        this.preArchivingEnabled = enabled;
    }

    public Integer getSearchPageSize() {
        return this.searchPageSize;
    }

    public Integer getMaxSecondsPerRun() {
        return this.maxSecondsPerRun;
    }

    public Integer getSleepSecondsBetweenReleases() {
        return this.sleepSecondsBetweenReleases;
    }
}

