package com.xebialabs.xlrelease.builder;

import java.util.List;

import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;

import static com.google.common.collect.Lists.newArrayList;

public class GateTaskBuilder extends TaskBuilder<GateTask, GateTaskBuilder> {
    private List<GateCondition> conditions = newArrayList();
    private List<Dependency> dependencies = newArrayList();
    private boolean transitionToFailed;

    public GateTaskBuilder withConditions(GateCondition... conditions) {
        this.conditions = newArrayList(conditions);
        return this;
    }

    public GateTaskBuilder withDependencies(Dependency... dependencies) {
        return withDependencies(newArrayList(dependencies));
    }

    public GateTaskBuilder withDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public GateTaskBuilder withTransitionToFailed(boolean transitionToFailed) {
        this.transitionToFailed = transitionToFailed;
        return this;
    }

    public static GateCondition unchecked(String id, String title) {
        return new GateCondition(id, title, false);
    }

    @Override
    protected void setFields(GateTask task) {
        super.setFields(task);
        task.setConditions(conditions);
        task.setDependencies(dependencies);
        task.setTransitionToFailed(transitionToFailed);
        dependencies.forEach(dependency -> dependency.setGateTask(task));
    }

    @Override
    public GateTask build() {
        GateTask task = new GateTask().getType().getDescriptor().newInstance("dummy");
        setFields(task);
        return task;
    }
}
