/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.VariableBuilder;
import com.xebialabs.xlrelease.domain.PollType;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.TriggerExecutionStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.Ids;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class ReleaseTriggerBuilder {
    private String type;
    private String id;
    private Integer ciUid;
    private String folderId = "";
    private String title;
    private String description;
    private List<Variable> vars = Lists.newArrayList();
    private Release template;
    private String templateId;
    private String executionId;
    private boolean enabled = true;
    private boolean misfireRecoveryEnabled = false;
    private String releaseTitle;
    private String triggerState;
    private PollType pollType = PollType.REPEAT;
    private String periodicity = "60";
    private List<String> tags = Lists.newArrayList();
    private Map<String, Object> properties = Maps.newHashMap();
    private boolean initialFire;
    private Date lastRunDate;
    private TriggerExecutionStatus lastRunStatus;
    private String releaseFolder;

    private ReleaseTriggerBuilder(String type) {
        this.type = type;
    }

    public static ReleaseTriggerBuilder newReleaseTrigger(String type) {
        return new ReleaseTriggerBuilder(type);
    }

    public ReleaseTriggerBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public ReleaseTriggerBuilder withCiUid(Integer ciUid) {
        this.ciUid = ciUid;
        return this;
    }

    public ReleaseTriggerBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public ReleaseTriggerBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ReleaseTriggerBuilder withIdAndTitle(String id) {
        this.id = id;
        this.title = id;
        return this;
    }

    public ReleaseTriggerBuilder withTemplateVariableValues(Map<String, String> values) {
        for (Map.Entry<String, String> var : values.entrySet()) {
            this.vars.add((Variable)VariableBuilder.newStringVariable((String)var.getKey(), (String)var.getValue()).build());
        }
        return this;
    }

    public ReleaseTriggerBuilder withTemplatePasswordVariableValues(Map<String, String> values) {
        for (Map.Entry<String, String> var : values.entrySet()) {
            this.vars.add((Variable)VariableBuilder.newPasswordStringVariable((String)var.getKey(), (String)var.getValue()).build());
        }
        return this;
    }

    public ReleaseTriggerBuilder withTemplateVariables(Variable ... variables) {
        this.vars.addAll(Arrays.asList(variables));
        return this;
    }

    public ReleaseTriggerBuilder withTemplateVariables(List<Variable> variables) {
        this.vars.addAll(variables);
        return this;
    }

    public ReleaseTriggerBuilder withTemplate(Release template) {
        this.template = template;
        this.folderId = Ids.findFolderId((String)template.getId());
        return this;
    }

    public ReleaseTriggerBuilder withTemplateId(String templateId) {
        this.templateId = templateId;
        this.folderId = Ids.findFolderId((String)templateId);
        return this;
    }

    public ReleaseTriggerBuilder withFolder(Folder folder) {
        this.folderId = folder.getId();
        return this;
    }

    public ReleaseTriggerBuilder withFolderId(String folderId) {
        this.folderId = folderId;
        return this;
    }

    public ReleaseTriggerBuilder withExecutionId() {
        this.executionId = UUID.randomUUID().toString();
        return this;
    }

    public ReleaseTriggerBuilder withExecutionId(String id) {
        this.executionId = id;
        return this;
    }

    public ReleaseTriggerBuilder withNoExecutionId() {
        this.executionId = null;
        return this;
    }

    public ReleaseTriggerBuilder withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ReleaseTriggerBuilder withMisfireRecoveryEnabled(boolean enabled) {
        this.misfireRecoveryEnabled = enabled;
        return this;
    }

    public ReleaseTriggerBuilder withReleaseTitle(String s) {
        this.releaseTitle = s;
        return this;
    }

    public ReleaseTriggerBuilder withTriggerState(String triggerState) {
        this.triggerState = triggerState;
        return this;
    }

    public ReleaseTriggerBuilder withInitialFire(boolean initialFire) {
        this.initialFire = initialFire;
        return this;
    }

    public ReleaseTriggerBuilder withPollType(PollType pollType) {
        this.pollType = pollType;
        return this;
    }

    public ReleaseTriggerBuilder withPeriodicity(String periodicity) {
        this.periodicity = periodicity;
        return this;
    }

    public ReleaseTriggerBuilder withProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public ReleaseTriggerBuilder withTags(String ... tags) {
        this.tags = Lists.newArrayList((Object[])tags);
        return this;
    }

    public ReleaseTriggerBuilder withLastRunDate(Date lastRunDate) {
        this.lastRunDate = lastRunDate;
        return this;
    }

    public ReleaseTriggerBuilder withLastRunStatus(TriggerExecutionStatus lastRunStatus) {
        this.lastRunStatus = lastRunStatus;
        return this;
    }

    public ReleaseTriggerBuilder withReleaseFolder(String releaseFolder) {
        this.releaseFolder = releaseFolder;
        return this;
    }

    public ReleaseTrigger build() {
        String templateFolderId;
        Type triggerType = Type.valueOf((String)this.type);
        ReleaseTrigger releaseTrigger = (ReleaseTrigger)triggerType.getDescriptor().newInstance(this.id);
        releaseTrigger.setCiUid(this.ciUid);
        releaseTrigger.setTitle(this.title);
        releaseTrigger.setDescription(this.description);
        releaseTrigger.setVariables(this.vars);
        if (Objects.nonNull(this.template)) {
            releaseTrigger.setTemplate(this.template.getId());
        } else if (!Strings.isNullOrEmpty((String)this.templateId)) {
            releaseTrigger.setTemplate(this.templateId);
        }
        if (!Strings.isNullOrEmpty((String)releaseTrigger.getTemplate()) && !(templateFolderId = Ids.findFolderId((String)releaseTrigger.getTemplate())).equals(this.folderId)) {
            throw new IllegalStateException("Trigger folder id does not match template folder id");
        }
        releaseTrigger.setExecutionId(this.executionId);
        releaseTrigger.setEnabled(this.enabled);
        releaseTrigger.setMisfireRecoveryEnabled(this.misfireRecoveryEnabled);
        releaseTrigger.setReleaseTitle(this.releaseTitle);
        releaseTrigger.setTriggerState(this.triggerState);
        releaseTrigger.setInitialFire(this.initialFire);
        releaseTrigger.setPollType(this.pollType);
        releaseTrigger.setPeriodicity(this.periodicity);
        releaseTrigger.setFolderId(this.folderId);
        releaseTrigger.setLastRunDate(this.lastRunDate);
        releaseTrigger.setLastRunStatus(this.lastRunStatus);
        releaseTrigger.setReleaseFolder(this.releaseFolder);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            releaseTrigger.setProperty(entry.getKey(), entry.getValue());
        }
        releaseTrigger.setTags(this.tags);
        return releaseTrigger;
    }
}

