/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.variables.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CreateReleaseTaskBuilder
extends TaskBuilder<CreateReleaseTask, CreateReleaseTaskBuilder> {
    private String newReleaseTitle;
    private String templateId;
    private String folderId;
    private List<Variable> variables = new ArrayList<Variable>();
    private String createdReleaseId;
    private boolean startRelease;
    private boolean waitForRelease;
    private Set<String> releaseTags = new HashSet<String>();

    public CreateReleaseTaskBuilder withNewReleaseTitle(String newReleaseTitle) {
        this.newReleaseTitle = newReleaseTitle;
        return this;
    }

    public CreateReleaseTaskBuilder withTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    public CreateReleaseTaskBuilder withFolderId(String folderId) {
        this.folderId = folderId;
        return this;
    }

    public CreateReleaseTaskBuilder withVariables(List<Variable> variables) {
        this.variables = variables;
        return this;
    }

    public CreateReleaseTaskBuilder withVariables(Variable ... variables) {
        return this.withVariables(Lists.newArrayList((Object[])variables));
    }

    public CreateReleaseTaskBuilder withCreatedReleaseId(String createdReleaseId) {
        this.createdReleaseId = createdReleaseId;
        return this;
    }

    public CreateReleaseTaskBuilder withStartRelease(boolean startRelease) {
        this.startRelease = startRelease;
        return this;
    }

    public CreateReleaseTaskBuilder withWaitForRelease(boolean waitForRelease) {
        this.waitForRelease = waitForRelease;
        return this;
    }

    public CreateReleaseTaskBuilder withReleaseTags(Set<String> releaseTags) {
        this.releaseTags = releaseTags;
        return this;
    }

    public CreateReleaseTaskBuilder withReleaseTags(String ... releaseTags) {
        this.releaseTags = Stream.of(releaseTags).collect(Collectors.toSet());
        return this;
    }

    @Override
    protected void setFields(CreateReleaseTask task) {
        super.setFields(task);
        task.setNewReleaseTitle(this.newReleaseTitle);
        task.setTemplateId(this.templateId);
        task.setFolderId(this.folderId);
        task.setTemplateVariables(this.variables);
        task.setCreatedReleaseId(this.createdReleaseId);
        task.setStartRelease(this.startRelease);
        task.setWaitForRelease(this.waitForRelease);
        task.setReleaseTags(this.releaseTags);
    }

    @Override
    public CreateReleaseTask build() {
        CreateReleaseTask task = (CreateReleaseTask)new CreateReleaseTask().getType().getDescriptor().newInstance("dummy");
        this.setFields(task);
        return task;
    }
}

