package com.xebialabs.xlrelease.builder;

import java.util.List;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;

import static com.google.common.collect.Lists.newArrayList;

public abstract class TaskGroupBuilder<T extends TaskGroup, S extends TaskGroupBuilder<T, S>> extends TaskBuilder<T, S> {
    private List<Task> tasks = newArrayList();

    public S withTasks(Task... tasks) {
        this.tasks = newArrayList(tasks);
        return self();
    }

    @Override
    protected void setFields(T group) {
        super.setFields(group);
        group.setTasks(tasks);
        for (Task subTask : tasks) {
            subTask.setContainer(group);
        }
    }
}
