package com.xebialabs.xlrelease.builder

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.builder.VariableBuilder.newVariable
import com.xebialabs.xlrelease.domain.variables.{FolderVariables, Variable}

import java.util.{List => JList, Map => JMap}
import scala.jdk.CollectionConverters._

object FolderVariableBuilder {
  def newFolderVariable(variableValues: JMap[String, String]): FolderVariables = {
    val variables: JList[Variable] = variableValues.asScala.toList.map {
      case (k, v) => newVariable(k, v): Variable
    }.asJava
    newFolderVariable(variables)
  }

  def newFolderVariable(variable: Variable): FolderVariables = {
    newFolderVariable(List(variable).asJava)
  }

  def newFolderVariable(variables: JList[Variable]): FolderVariables = {
    val folder: FolderVariables = Type.valueOf(classOf[FolderVariables]).getDescriptor
      .newInstance("Applications/{folderId}/variables")
    folder.setVariables(variables)
    folder
  }
}
