package com.xebialabs.xlrelease.builder;

import java.util.List;

import com.xebialabs.xlrelease.domain.Team;

import static com.google.common.collect.Lists.newArrayList;

public class TeamBuilder {
    private String id;
    private String teamName;
    private List<String> members = newArrayList();
    private List<String> roles = newArrayList();
    private List<String> permissions = newArrayList();

    public static TeamBuilder newTeam() {
        return new TeamBuilder();
    }

    public TeamBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public TeamBuilder withTeamName(String teamName) {
        this.teamName = teamName;
        return this;
    }

    public TeamBuilder withMembers(String... members) {
        return withMembers(newArrayList(members));
    }

    public TeamBuilder withMembers(List<String> members) {
        this.members = members;
        return this;
    }

    public TeamBuilder withRoles(String... roles) {
        return withRoles(newArrayList(roles));
    }

    public TeamBuilder withRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public TeamBuilder withPermissions(String... permissions) {
        return withPermissions(newArrayList(permissions));
    }

    public TeamBuilder withPermissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public Team build() {
        Team team = new Team().getType().getDescriptor().newInstance(id);
        team.setTeamName(teamName);
        team.setMembers(members);
        team.setRoles(roles);
        team.setPermissions(permissions);

        return team;
    }
}
