package com.xebialabs.xlrelease.builder

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.builder.VariableBuilder.newVariable
import com.xebialabs.xlrelease.domain.variables.GlobalVariables.GLOBAL_VARIABLES_ID
import com.xebialabs.xlrelease.domain.variables.{GlobalVariables, Variable}

import java.util.{List => JList, Map => JMap}
import scala.jdk.CollectionConverters._

object GlobalVariablesBuilder {

  def newGlobalVariablesCi(variableValues: JMap[String, String]): GlobalVariables = {
    val variables: JList[Variable] = variableValues.asScala.toList.map {
      case (k, v) => newVariable(k, v): Variable
    }.asJava
    newGlobalVariablesCi(variables)
  }

  def newGlobalVariablesCi(variable: Variable): GlobalVariables = {
    newGlobalVariablesCi(List(variable).asJava)
  }

  def newGlobalVariablesCi(variables: JList[Variable]): GlobalVariables = {
    val global: GlobalVariables = Type.valueOf(classOf[GlobalVariables]).getDescriptor
      .newInstance(GLOBAL_VARIABLES_ID)
    global.setVariables(variables)
    global
  }
}
