package com.xebialabs.xlrelease.domain.utils

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.domain.{Release, ReleaseTrigger, Task}
import com.xebialabs.xlrelease.repository.Ids._
import com.xebialabs.xlrelease.utils.CiHelper.getNestedCis

import java.util.UUID
import scala.jdk.CollectionConverters._

object IdUtils {

  def createMissingNestedIds(ci: ConfigurationItem): Unit = {
    val parentId = ci.getId

    for (nestedCi <- getNestedCis(ci).asScala) {
      if (nestedCi.getId == null) {
        val newID = getUniqueId(nestedCi.getType(), parentId)
        nestedCi.setId(newID)
      }
    }
  }

  def getUniqueId(t: Type, parentId: String): String = getUniqueId(prefixByClass(t), parentId)

  def getUniqueId(t: String, parentId: String): String = s"$parentId$SEPARATOR$t${uuidString()}"


  private def uuidString(): String = UUID.randomUUID().toString.filterNot(_ == '-')

  private def prefixByClass(itemClass: Type): String = itemClass match {
    case a if a.getDescriptor.isAssignableTo(classOf[Release]) =>
      RELEASE_PREFIX
    case a if a.getDescriptor.isAssignableTo(classOf[ReleaseTrigger]) =>
      TRIGGER_PREFIX
    case a if a.getDescriptor.isAssignableTo(classOf[Task]) =>
      TASK_PREFIX
    case a if a.getDescriptor.isAssignableTo(classOf[Variable]) =>
      VARIABLE_PREFIX
    case t => t.getName
  }

}
