package com.xebialabs.xlrelease.builder;

import java.util.Set;

import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;

import static com.google.common.collect.Sets.newHashSet;

public class ParallelGroupBuilder extends TaskGroupBuilder<ParallelGroup, ParallelGroupBuilder> {

    private Set<Link> links = newHashSet();

    public ParallelGroupBuilder withLinks(Link... links) {
        this.links = newHashSet(links);
        return this;
    }

    @Override
    protected void setFields(ParallelGroup group) {
        super.setFields(group);
        group.setLinks(links);
    }

    @Override
    public ParallelGroup build() {
        ParallelGroup group = new ParallelGroup().getType().getDescriptor().newInstance("dummy");
        setFields(group);
        links.forEach(link -> link.setParallelGroup(group));
        return group;
    }
}
