package com.xebialabs.xlrelease.builder;

import com.xebialabs.xlrelease.domain.BaseScriptTask;

import static java.util.UUID.randomUUID;

public abstract class BaseScriptTaskBuilder<T extends BaseScriptTask, S extends TaskBuilder<T, S>> extends TaskBuilder<T, S> {
    private String executionId;

    public S withExecutionId() {
        this.executionId = randomUUID().toString();
        return self();
    }

    @Override
    protected void setFields(T task) {
        super.setFields(task);
        task.setExecutionId(executionId);
    }
}
