/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.RemoteScriptExecution;
import java.util.Map;

public class RemoteScriptExecutionBuilder {
    private String type;
    private Map<String, Object> inputParameters = Maps.newHashMap();
    private Map<String, Object> outputProperties = Maps.newHashMap();
    private String statusLine;
    private boolean keepPreviousOutputPropertiesOnRetry;

    public RemoteScriptExecutionBuilder(String type) {
        this.type = type;
    }

    public RemoteScriptExecutionBuilder withInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
        return this;
    }

    public RemoteScriptExecutionBuilder withOutputProperties(Map<String, Object> outputProperties) {
        this.outputProperties = outputProperties;
        return this;
    }

    public RemoteScriptExecutionBuilder withStatusLine(String statusLine) {
        this.statusLine = statusLine;
        return this;
    }

    public RemoteScriptExecutionBuilder withKeepPreviousOutputPropertiesOnRetry(boolean keepPreviousOutputPropertiesOnRetry) {
        this.keepPreviousOutputPropertiesOnRetry = keepPreviousOutputPropertiesOnRetry;
        return this;
    }

    public RemoteScriptExecution build() {
        RemoteScriptExecution execution = (RemoteScriptExecution)Type.valueOf((String)this.type).getDescriptor().newInstance(null);
        execution.setStatusLine(this.statusLine);
        for (Map.Entry<String, Object> entry : this.inputParameters.entrySet()) {
            execution.setProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.outputProperties.entrySet()) {
            execution.setProperty(entry.getKey(), entry.getValue());
        }
        return execution;
    }
}

