package com.xebialabs.xlrelease.domain.utils

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain._

import scala.jdk.CollectionConverters._

object syntax {

  implicit class TaskOps(val task: Task) extends AnyVal {
    def asGateTask: Option[GateTask] = task match {
      case gate: GateTask => Some(gate)
      case _ => None
    }

    def comments: Iterable[Comment] = task.getComments.asScala

    def dependencies: Iterable[Dependency] = asGateTask.toSeq.flatMap(_.getDependencies.asScala.toSeq)

    def allDependencies: Iterable[Dependency] = task match {
      case g: TaskGroup => g.getAllTasks.asScala.filter(_.isInstanceOf[GateTask]).flatMap(_.allDependencies)
      case g: GateTask => g.dependencies
      case _ => Iterable.empty
    }
  }

  implicit class ConfigurationItemOps(val ci: ConfigurationItem) extends AnyVal {
    def getPropertyOption[T](key: String): Option[T] = if (ci.hasProperty(key)) Option(ci.getProperty[T](key)) else None
  }

}
