package com.xebialabs.xlrelease.domain.utils;

import java.util.Date;

import com.xebialabs.xlrelease.domain.Comment;

public abstract class CommentServiceHelper {

    private CommentServiceHelper() {
    }

    public static void appendCommentText(final Comment comment, final String commentText, final int maxCommentSize, final String prefix, final String suffix) {
        StringBuilder sb = new StringBuilder(removeExistingPrefixAndSuffix(comment.getText(), prefix, suffix));
        sb.append(commentText);
        if (maxCommentSize == 0) {
            sb = new StringBuilder();
        }
        if (maxCommentSize > 0 && sb.length() > maxCommentSize) {
            sb.delete(maxCommentSize, sb.length());
            sb.insert(0, prefix);
            sb.append(suffix);
        }
        String truncatedComment = sb.toString();
        comment.setText(truncatedComment);
        if (comment.getDate() != null) {
            // we are updating an existing comment
            comment.setDate(new Date());
        } else {
            comment.setDate(comment.getCreationDate());
        }
    }


    public static void updateCommentText(final Comment comment, final String newText, final int maxCommentSize, final String prefix, final String suffix) {
        if (!newText.equals(comment.getText())) {
            comment.setText("");
            appendCommentText(comment, removeExistingPrefixAndSuffix(newText, prefix, suffix), maxCommentSize, prefix, suffix);
        }
    }

    private static String removeExistingPrefixAndSuffix(final String existingComment, final String prefix, final String suffix) {
        StringBuilder sb = new StringBuilder();
        if (null != existingComment) {
            sb.append(existingComment);
            if (existingComment.startsWith(prefix)) {
                sb.delete(0, prefix.length());
            }
            if (existingComment.endsWith(suffix)) {
                sb.delete(sb.length() - suffix.length(), sb.length());
            }
        }
        return sb.toString();
    }
}
