package com.xebialabs.xlrelease.builder;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;

import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.xlrelease.domain.PythonScript.PYTHON_SCRIPT_ID;

public class CustomScriptTaskBuilder extends BaseScriptTaskBuilder<CustomScriptTask, CustomScriptTaskBuilder> {
    private String type;

    private String scriptDefinitionType;

    private boolean keepPreviousOutputPropertiesOnRetry;

    private Map<String, Object> inputParameters = newHashMap();

    private Map<String, Object> outputProperties = newHashMap();

    private String statusLine;

    public CustomScriptTaskBuilder(String scriptDefinitionType) {
        this.scriptDefinitionType = scriptDefinitionType;
    }

    public CustomScriptTaskBuilder(String scriptDefinitionType, String type) {
        this.scriptDefinitionType = scriptDefinitionType;
        this.type = type;
    }

    public CustomScriptTaskBuilder withInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
        return this;
    }

    public CustomScriptTaskBuilder withOutputProperties(Map<String, Object> outputProperties) {
        this.outputProperties = outputProperties;
        return this;
    }

    public CustomScriptTaskBuilder withStatusLine(String statusLine) {
        this.statusLine = statusLine;
        return this;
    }

    public CustomScriptTaskBuilder withKeepPreviousOutputPropertiesOnRetry(final boolean keepPreviousOutputPropertiesOnRetry) {
        this.keepPreviousOutputPropertiesOnRetry = keepPreviousOutputPropertiesOnRetry;
        return this;
    }

    @Override
    public CustomScriptTask build() {
        CustomScriptTask task = Type.valueOf(CustomScriptTask.class).getDescriptor().newInstance(null);
        setFields(task);
        PythonScript pythonScript;
        if (type == null) {
            pythonScript = Type.valueOf(scriptDefinitionType).getDescriptor().newInstance(task.getId() + "/" + PYTHON_SCRIPT_ID);
        } else {
            pythonScript = Type.valueOf(type).getDescriptor().newInstance(task.getId() + "/" + PYTHON_SCRIPT_ID);
        }

        task.setPythonScript(pythonScript);
        pythonScript.setCustomScriptTask(task);
        for (Map.Entry<String, Object> entry : inputParameters.entrySet()) {
            pythonScript.setProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : outputProperties.entrySet()) {
            pythonScript.setProperty(entry.getKey(), entry.getValue());
        }
        task.setStatusLine(statusLine);
        task.setKeepPreviousOutputPropertiesOnRetry(keepPreviousOutputPropertiesOnRetry);

        return task;
    }
}
