/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.builder.TeamBuilder;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.FolderVariables;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.variable.VariableFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReleaseBuilder {
    private String id;
    private Integer ciUid;
    private String title = "Test Title";
    private String description;
    private ReleaseStatus status = ReleaseStatus.PLANNED;
    private List<Phase> phases;
    private Date scheduledStartDate;
    private boolean autoStart;
    private Date dueDate;
    private Date startDate;
    private Date endDate;
    private List<Team> teams = Lists.newArrayList();
    private String owner;
    private List<Variable> variables = Lists.newArrayList();
    private List<String> tags = Lists.newArrayList();
    private FlagStatus flagStatus = FlagStatus.OK;
    private String flagComment;
    private String calendarToken;
    private boolean calendarPublished;
    private boolean tutorial;
    private boolean abortOnFailure;
    private boolean allowPasswordsInAllFields;
    private boolean disableNotifications;
    private boolean allowConcurrentReleasesFromTrigger = true;
    private List<Attachment> attachments = Lists.newArrayList();
    private String originTemplateId;
    private Integer plannedDuration;
    private String scriptUsername;
    private String scriptUserPassword;
    private boolean overdueNotified;
    private GlobalVariables globalVariables;
    private FolderVariables folderVariables;
    private List<ReleaseExtension> extensions = Lists.newArrayList();
    private int maxConcurrency = -1;
    private Map<String, InternalMetadata> metadata = new HashMap<String, InternalMetadata>();
    private Map<String, String> variableMapping = new HashMap<String, String>();
    private CiAttributes ci$attributes = new CiAttributes(null, null, null, null, null);

    private ReleaseBuilder() {
    }

    public static ReleaseBuilder newRelease() {
        return new ReleaseBuilder();
    }

    public static ReleaseBuilder newTemplate() {
        return new ReleaseBuilder().withStatus(ReleaseStatus.TEMPLATE);
    }

    public ReleaseBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public ReleaseBuilder withCiUid(Integer ciUid) {
        this.ciUid = ciUid;
        return this;
    }

    public ReleaseBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public ReleaseBuilder withIdAndTitle(String id) {
        this.id = id;
        this.title = id;
        return this;
    }

    public ReleaseBuilder withStatus(ReleaseStatus status) {
        this.status = status;
        return this;
    }

    public ReleaseBuilder completed() {
        this.status = ReleaseStatus.COMPLETED;
        if (this.startDate == null) {
            this.startDate = new Date();
        }
        if (this.endDate == null) {
            this.endDate = new Date();
        }
        return this;
    }

    public ReleaseBuilder withPhases(Phase ... phases) {
        this.phases = Lists.newArrayList((Object[])phases);
        return this;
    }

    public ReleaseBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ReleaseBuilder withScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
        return this;
    }

    public ReleaseBuilder withAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
        return this;
    }

    public ReleaseBuilder withDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public ReleaseBuilder withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public ReleaseBuilder withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public ReleaseBuilder withCurrentDates() {
        this.withScheduledStartDate(new Date());
        this.withDueDate(new Date());
        return this;
    }

    public ReleaseBuilder withPlannedDuration(Integer plannedDuration) {
        this.plannedDuration = plannedDuration;
        return this;
    }

    public ReleaseBuilder withTeams(Team ... teams) {
        return this.withTeams(Lists.newArrayList((Object[])teams));
    }

    public ReleaseBuilder withTeams(List<Team> teams) {
        ArrayList<Team> newTeams = new ArrayList<Team>(teams);
        newTeams.addAll(this.teams);
        this.teams = newTeams;
        return this;
    }

    public ReleaseBuilder withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public ReleaseBuilder withOverdueNotified(boolean overdueNotified) {
        this.overdueNotified = overdueNotified;
        return this;
    }

    public ReleaseBuilder withVariableValues(Map<String, ?> variableValues) {
        this.variables.addAll(this.toVariables(variableValues, false));
        return this;
    }

    public ReleaseBuilder withPasswordVariableValues(Map<String, ?> passwordVariables) {
        this.variables.addAll(this.toVariables(passwordVariables, true));
        return this;
    }

    public ReleaseBuilder withVariables(List<Variable> variables) {
        this.variables = variables;
        return this;
    }

    public ReleaseBuilder withVariables(Variable ... variables) {
        return this.withVariables(Lists.newArrayList((Object[])variables));
    }

    public ReleaseBuilder withGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
        return this;
    }

    public ReleaseBuilder withFolderVariables(FolderVariables folderVariables) {
        this.folderVariables = folderVariables;
        return this;
    }

    public ReleaseBuilder withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ReleaseBuilder withTags(String ... tags) {
        return this.withTags(Lists.newArrayList((Object[])tags));
    }

    public ReleaseBuilder withFlagStatus(FlagStatus flagStatus) {
        this.flagStatus = flagStatus;
        return this;
    }

    public ReleaseBuilder withFlagComment(String flagComment) {
        this.flagComment = flagComment;
        return this;
    }

    public ReleaseBuilder withCalendarToken(String calendarToken) {
        this.calendarToken = calendarToken;
        return this;
    }

    public ReleaseBuilder withCalendarPublished(boolean calendarPublished) {
        this.calendarPublished = calendarPublished;
        return this;
    }

    public ReleaseBuilder withTutorial(boolean tutorial) {
        this.tutorial = tutorial;
        return this;
    }

    public ReleaseBuilder withAbortOnFailure(boolean abortOnFailure) {
        this.abortOnFailure = abortOnFailure;
        return this;
    }

    public ReleaseBuilder withAllowPasswordsInAllFields(boolean allowPasswordsInAllFields) {
        this.allowPasswordsInAllFields = allowPasswordsInAllFields;
        return this;
    }

    public ReleaseBuilder withDisableNotifications(boolean disableNotifications) {
        this.disableNotifications = disableNotifications;
        return this;
    }

    public ReleaseBuilder withAllowConcurrentReleasesFromTrigger(boolean val) {
        this.allowConcurrentReleasesFromTrigger = val;
        return this;
    }

    public ReleaseBuilder withAttachments(Attachment ... attachments) {
        this.attachments = Lists.newArrayList((Object[])attachments);
        return this;
    }

    public ReleaseBuilder withOriginTemplateId(String originTemplateId) {
        this.originTemplateId = originTemplateId;
        return this;
    }

    public ReleaseBuilder withMemberViewers(String ... members) {
        Team viewersTeam = this.createOrFindViewersTeam();
        viewersTeam.addMembers(members);
        return this;
    }

    public ReleaseBuilder withRoleViewers(String ... roles) {
        Team viewersTeam = this.createOrFindViewersTeam();
        viewersTeam.addRoles(roles);
        return this;
    }

    private Team createOrFindViewersTeam() {
        return this.teams.stream().filter(team -> team.getTeamName().equals("Viewers team")).findFirst().orElseGet(() -> {
            Team viewersTeam = TeamBuilder.newTeam().withTeamName("Viewers team").withPermissions(XLReleasePermissions.VIEW_RELEASE.getPermissionName()).build();
            this.teams.add(viewersTeam);
            return viewersTeam;
        });
    }

    public ReleaseBuilder withScriptUsername(String scriptUsername) {
        this.scriptUsername = scriptUsername;
        return this;
    }

    public ReleaseBuilder withScriptUserPassword(String scriptUserPassword) {
        this.scriptUserPassword = scriptUserPassword;
        return this;
    }

    public ReleaseBuilder addExtension(ReleaseExtension extension) {
        this.extensions.add(extension);
        return this;
    }

    public ReleaseBuilder withMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public ReleaseBuilder withMetadata(String key, InternalMetadata metadata) {
        this.metadata.put(key, metadata);
        return this;
    }

    public ReleaseBuilder withVariableMapping(Map<String, String> variableMapping) {
        this.variableMapping = variableMapping;
        return this;
    }

    public ReleaseBuilder withCiAttributes(CiAttributes ci$Attributes) {
        this.ci$attributes = ci$Attributes;
        return this;
    }

    public Release build() {
        Release release = (Release)new Release().getType().getDescriptor().newInstance(this.id);
        release.setCiUid(this.ciUid);
        release.setStatus(this.status);
        release.setTitle(this.title);
        release.setDescription(this.description);
        release.setScheduledStartDate(this.scheduledStartDate);
        release.setAutoStart(this.autoStart);
        release.setDueDate(this.dueDate);
        release.setStartDate(this.startDate);
        release.setEndDate(this.endDate);
        release.setPlannedDuration(this.plannedDuration);
        release.setTags(this.tags);
        release.setFlagStatus(this.flagStatus);
        release.setFlagComment(this.flagComment);
        release.setCalendarLinkToken(this.calendarToken);
        release.setCalendarPublished(this.calendarPublished);
        release.setTutorial(this.tutorial);
        release.setAbortOnFailure(this.abortOnFailure);
        release.setAllowPasswordsInAllFields(this.allowPasswordsInAllFields);
        release.setDisableNotifications(this.disableNotifications);
        release.setAllowConcurrentReleasesFromTrigger(this.allowConcurrentReleasesFromTrigger);
        release.setOriginTemplateId(this.originTemplateId);
        release.setScriptUsername(this.scriptUsername);
        release.setScriptUserPassword(this.scriptUserPassword);
        release.setOverdueNotified(this.overdueNotified);
        release.setExtensions(this.extensions);
        release.setVariableMapping(this.variableMapping);
        release.get$metadata().putAll(this.metadata);
        release.set$ciAttributes(this.ci$attributes);
        if (null != this.teams) {
            this.teams.stream().filter(team -> "TeamViewers".equals(team.getId())).forEach(team -> team.setId(this.id + "/TeamViewers"));
            release.setTeams(this.teams);
        }
        if (null != this.phases) {
            for (Phase phase : this.phases) {
                phase.setRelease(release);
            }
            release.setPhases(this.phases);
        }
        release.setOwner(this.owner);
        release.setAttachments(this.attachments);
        if (this.maxConcurrency >= 0) {
            release.setMaxConcurrentReleases(this.maxConcurrency);
        }
        release.setQueryableStartDate(release.getStartOrScheduledDate());
        release.setQueryableEndDate(release.getEndOrDueDate());
        release.setVariables(this.variables);
        release.setGlobalVariables(this.globalVariables);
        release.setFolderVariables(this.folderVariables);
        return release;
    }

    private List<Variable> toVariables(Map<String, ?> values, boolean isPassword) {
        return values.entrySet().stream().map(e -> VariableFactory.createVariableByValueType((String)((String)e.getKey()), e.getValue(), (boolean)isPassword, (boolean)false)).collect(Collectors.toList());
    }
}

