/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.rules;

import com.xebialabs.xlrelease.domain.events.EventBus;
import java.util.ArrayList;
import java.util.List;
import nl.javadude.t2bus.Subscribe;
import org.junit.rules.ExternalResource;

public class EventsRule<T>
extends ExternalResource {
    private EventBus eventBus;
    private Class<T> eventClass;
    private List<T> capturedEvents = new ArrayList<T>();

    public EventsRule(EventBus eventBus, Class<T> eventClass) {
        this.eventBus = eventBus;
        this.eventClass = eventClass;
    }

    public void before() {
        this.eventBus.register((Object)this);
    }

    public void after() {
        this.eventBus.deregister((Object)this);
    }

    @Subscribe
    public void eventCaptured(T event) {
        if (this.eventClass.isInstance(event)) {
            this.capturedEvents.add(event);
        }
    }

    public List<T> getCapturedEvents() {
        return this.capturedEvents;
    }
}

