package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;

import static com.xebialabs.xlrelease.domain.variables.reference.VariableReference.VariableUsageType;

public class VariableReferenceAssertion extends AbstractAssert<VariableReferenceAssertion, VariableReference> {

    protected VariableReferenceAssertion(VariableReference actual) {
        super(actual, VariableReferenceAssertion.class);
    }

    public VariableReferenceAssertion hasKey(String key) {
        isNotNull();
        Assertions.assertThat(actual.getKey()).isEqualTo(key);
        return this;
    }

    public VariableReferenceAssertion hasType(VariableUsageType type) {
        isNotNull();
        Assertions.assertThat(actual.getType()).isEqualTo(type);
        return this;
    }
}
