package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

import com.xebialabs.xlrelease.domain.Team;

public class TeamAssertion extends AbstractAssert<TeamAssertion, Team> {

    protected TeamAssertion(Team actual) {
        super(actual, TeamAssertion.class);
    }

    public TeamAssertion hasPermissions(String... permissionNames) {
        isNotNull();
        Assertions.assertThat(actual.getPermissions()).containsOnly(permissionNames);
        return this;
    }

    public TeamAssertion hasNoPermissions() {
        isNotNull();
        Assertions.assertThat(actual.getPermissions()).isEmpty();
        return this;
    }

    public TeamAssertion hasTeamName(String teamName) {
        isNotNull();
        Assertions.assertThat(actual.getTeamName()).isEqualTo(teamName);
        return this;
    }

    public TeamAssertion hasRoles(String... roles) {
        isNotNull();
        Assertions.assertThat(actual.getRoles()).containsOnly(roles);
        return this;
    }

    public TeamAssertion hasMembers(String... members) {
        isNotNull();
        Assertions.assertThat(actual.getMembers()).containsOnly(members);
        return this;
    }
}
