package com.xebialabs.xlrelease

import com.xebialabs.xlrelease.rules.LoginRule
import org.scalatest.{BeforeAndAfterEach, Suite}

trait Login extends BeforeAndAfterEach {
  this: Suite =>

  def username: String

  lazy val loginRule: LoginRule = LoginRule.loginWith(username)

  override protected def beforeEach(): Unit = {
    loginRule.before()
    super.beforeEach()
  }

  override protected def afterEach(): Unit = {
    super.afterEach()
    loginRule.after()
  }
}
