package com.xebialabs.xlrelease;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

public class ClassPathResources {
    public static byte[] getBytes(String resourceName) throws IOException {
        try (InputStream in = getInputStream(resourceName)) {
            return StreamUtils.copyToByteArray(in);
        }
    }

    public static String getString(String resourceName, Charset charset) throws IOException {
        try (InputStream in = getInputStream(resourceName)) {
            return StreamUtils.copyToString(in, charset);
        }
    }

    public static InputStream getInputStream(String resourceName) throws IOException {
        return getResource(resourceName).getInputStream();
    }

    private static Resource getResource(String resourceName) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        return resourceLoader.getResource(resourceName);
    }
}
