package com.xebialabs.xlrelease.domain

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable

import java.util

@Metadata(label = "Test external variable server")
class TestExternalVariableServer extends ExternalVariableServer {
  override def lookup(variables: util.List[PasswordStringVariable]): util.Map[String, String] = {
    val lookupMap = new util.HashMap[String, String]()
    variables.forEach { variable =>
      val externalVariableValue = variable.getExternalVariableValue
      val path = externalVariableValue.getPath
      val key = externalVariableValue.getExternalKey
      lookupMap.put(
        variable.getKey,
        s"$path/$key"
      )
    }
    lookupMap
  }
}