package com.xebialabs.xlrelease

import com.xebialabs.xlrelease.rules.LoginRule
import org.springframework.security.core.Authentication
import org.springframework.security.core.context.SecurityContextHolder

trait TestAuthentication {

  def withAuthentication[T](auth: Authentication)(t: => T): T = {
    val origCtxt = SecurityContextHolder.getContext
    val newCtxt = SecurityContextHolder.createEmptyContext()
    newCtxt.setAuthentication(auth)
    SecurityContextHolder.setContext(newCtxt)
    try {
      t
    } finally {
      SecurityContextHolder.setContext(origCtxt)
    }
  }

  protected def asAdmin[T](block: => T): T = {
    val auth = LoginRule.loginWithRoleAdmin("admin").getAuthentication
    withAuthentication(auth) {
      block
    }
  }
}
