package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.utils.ReleaseSoftReference;

public class ReleaseStrongReferenceForTests extends ReleaseSoftReference {
    Release strongRef;
    public ReleaseStrongReferenceForTests(final Release release) {
        super(release, null);
        strongRef = release;
    }

    public static ReleaseSoftReference testRef(Release release) {
        return new ReleaseStrongReferenceForTests(release);
    }

    @Override
    public Release get() {
        return strongRef;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final com.xebialabs.xlrelease.utils.ReleaseStrongReferenceForTests that = (com.xebialabs.xlrelease.utils.ReleaseStrongReferenceForTests) o;

        return strongRef != null ? strongRef.equals(that.strongRef) : that.strongRef == null;
    }

    @Override
    public int hashCode() {
        return strongRef != null ? strongRef.hashCode() : 0;
    }
}
