package com.xebialabs.xlrelease.assertions;

import java.util.List;
import org.assertj.core.api.Assertions;

import com.xebialabs.xlrelease.domain.*;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;

/**
 * Brings our custom assertions into scope. Use this instead of the default FEST Assert class.
 */
public class XLReleaseAssertions extends Assertions {

    public static PhaseAssertion assertThat(Phase phase) {
        return new PhaseAssertion(phase);
    }

    public static ReleaseAssertion assertThat(Release release) {
        return new ReleaseAssertion(release);
    }

    public static TaskAssertion assertThat(Task task) {
        return new TaskAssertion(task);
    }

    public static ChangesAssertion assertThat(Changes actual) {
        return new ChangesAssertion(actual);
    }

    public static VariableReferenceAssertion assertThat(VariableReference actual) {
        return new VariableReferenceAssertion(actual);
    }

    public static VariableAssertion assertThat(Variable actual) {
        return new VariableAssertion(actual);
    }

    public static TeamAssertion assertThat(Team actual) {
        return new TeamAssertion(actual);
    }

    public static TeamListAssertion assertThatTeamList(List<Team> actual) {
        return new TeamListAssertion(actual);
    }

    public static ReleaseTriggerAssertion assertThat(ReleaseTrigger actual) {
        return new ReleaseTriggerAssertion(actual);
    }

    public static AttachmentAssertion assertThat(Attachment actual) {
        return new AttachmentAssertion(actual);
    }
}
